/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;

@ImplementedBy(value=BasketStructurerRuleDefault.class)
public abstract class BasketStructurerRule
implements ReportFunction<ReportableEvent, String> {
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;

    public String evaluate(ReportableEvent input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(ReportableEvent var1);

    public static class BasketStructurerRuleDefault
    extends BasketStructurerRule {
        @Override
        protected String doEvaluate(ReportableEvent input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, ReportableEvent input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> item.map("getReportableInformation", reportableEvent -> reportableEvent.getReportableInformation()).map("getCustomBasket", reportableInformation -> reportableInformation.getCustomBasket()).map("getBasketStructurerLei", customBasket -> customBasket.getBasketStructurerLei()));
            MapperS thenArg2 = thenArg1.filterSingleNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)PartyIdentifierTypeEnum.LEI), (CardinalityOperator)CardinalityOperator.All).get());
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg2.mapSingleToItem(item -> item.map("getIdentifier", partyIdentifier -> partyIdentifier.getIdentifier())).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

