/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeEROR;
import drr.regulation.common.functions.IsActionTypePRTO;
import drr.regulation.common.functions.IsActionTypeTERM;
import java.time.ZonedDateTime;
import javax.inject.Inject;

@ImplementedBy(value=EventTimestampRuleDefault.class)
public abstract class EventTimestampRule
implements ReportFunction<TransactionReportInstruction, ZonedDateTime> {
    @Inject
    protected drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule eventTimestampRule;
    @Inject
    protected IsActionTypeEROR isActionTypeEROR;
    @Inject
    protected IsActionTypePRTO isActionTypePRTO;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;

    public ZonedDateTime evaluate(TransactionReportInstruction input) {
        ZonedDateTime output = this.doEvaluate(input);
        return output;
    }

    protected abstract ZonedDateTime doEvaluate(TransactionReportInstruction var1);

    public static class EventTimestampRuleDefault
    extends EventTimestampRule {
        @Override
        protected ZonedDateTime doEvaluate(TransactionReportInstruction input) {
            ZonedDateTime output = null;
            return this.assignOutput(output, input);
        }

        protected ZonedDateTime assignOutput(ZonedDateTime output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypeTERM.evaluate((ReportableEvent)item.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypeEROR.evaluate((ReportableEvent)item.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypePRTO.evaluate((ReportableEvent)item.get())))).get());
            output = (ZonedDateTime)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.eventTimestampRule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

