/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.trade.CFTCPart45TransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbDeliveryTypeEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart45TransactionReportFixingDateCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart45TransactionReportFixingDateCondition
extends Validator<CFTCPart45TransactionReport> {
    public static final String NAME = "CFTCPart45TransactionReportFixingDateCondition";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Foreign_Exchange or dtccAdditionalFields -> primaryAssetClass = ForeignExchange) then (if ([AnnaDsbInstrumentTypeEnum -> Forward, AnnaDsbInstrumentTypeEnum -> Option] any = nonReportable -> postUpiData -> Header -> InstrumentType or [AnnaDsbInstrumentTypeEnum -> Forward, AnnaDsbInstrumentTypeEnum -> Option] any = nonReportable -> instrumentType) and (nonReportable -> postUpiData -> Attributes -> DeliveryType = CASH or nonReportable -> deliveryType = CASH) then (leg1 -> fixingDate exists or leg2 -> fixingDate exists) else (leg1 -> fixingDate is absent and leg2 -> fixingDate is absent))";

    public static class NoOp
    implements CFTCPart45TransactionReportFixingDateCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart45TransactionReportFixingDateCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart45TransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart45TransactionReportFixingDateCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportFixingDateCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart45TransactionReportFixingDateCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportFixingDateCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getDtccAdditionalFields", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.FOREIGN_EXCHANGE), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.FORWARD)), MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION))}), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (CardinalityOperator)CardinalityOperator.Any).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.FORWARD)), MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION))}), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getInstrumentType", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getInstrumentType()), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getAttributes", annaDsbUpiRecord -> annaDsbUpiRecord.getAttributes()).map("getDeliveryType", annaDsbAttributesRecord -> annaDsbAttributesRecord.getDeliveryType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbDeliveryTypeEnum.CASH)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getDeliveryType", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getDeliveryType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbDeliveryTypeEnum.CASH)), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getFixingDate", cFTCPart45Leg -> cFTCPart45Leg.getFixingDate())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getFixingDate", cFTCPart45Leg -> cFTCPart45Leg.getFixingDate())));
                    }
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getFixingDate", cFTCPart45Leg -> cFTCPart45Leg.getFixingDate())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getFixingDate", cFTCPart45Leg -> cFTCPart45Leg.getFixingDate())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

