/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.trade.CFTCPart45TransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart45TransactionReportNotionalQuantityCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart45TransactionReportNotionalQuantityCondition
extends Validator<CFTCPart45TransactionReport> {
    public static final String NAME = "CFTCPart45TransactionReportNotionalQuantityCondition";
    public static final String DEFINITION = "if dtccAdditionalFields -> primaryAssetClass <> Commodity or nonReportable -> postUpiData -> Header -> AssetClass <> Commodities then leg1 -> notionalQuantity is absent and leg2 -> notionalQuantity is absent";

    public static class NoOp
    implements CFTCPart45TransactionReportNotionalQuantityCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart45TransactionReportNotionalQuantityCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart45TransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart45TransactionReportNotionalQuantityCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportNotionalQuantityCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart45TransactionReportNotionalQuantityCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportNotionalQuantityCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getDtccAdditionalFields", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.COMMODITY), (CardinalityOperator)CardinalityOperator.Any).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.COMMODITIES)), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getNotionalQuantity", cFTCPart45Leg -> cFTCPart45Leg.getNotionalQuantity())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getNotionalQuantity", cFTCPart45Leg -> cFTCPart45Leg.getNotionalQuantity())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

