/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.CollateralDetails;
import drr.regulation.common.ReportableCollateral;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.meta.CollateralReportInstructionMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralReportInstruction", builder=CollateralReportInstructionBuilderImpl.class, version="6.21.2")
@RuneDataType(value="CollateralReportInstruction", model="drr", builder=CollateralReportInstructionBuilderImpl.class, version="6.21.2")
public interface CollateralReportInstruction
extends ReportableCollateral {
    public static final CollateralReportInstructionMeta metaData = new CollateralReportInstructionMeta();

    public ReportingSide getReportingSide();

    @Override
    public CollateralReportInstruction build();

    @Override
    public CollateralReportInstructionBuilder toBuilder();

    public static CollateralReportInstructionBuilder builder() {
        return new CollateralReportInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralReportInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralReportInstruction> getType() {
        return CollateralReportInstruction.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.class, this.getCollateralDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, this.getReportingSide(), new AttributeMeta[0]);
    }

    public static class CollateralReportInstructionBuilderImpl
    extends ReportableCollateral.ReportableCollateralBuilderImpl
    implements CollateralReportInstructionBuilder {
        protected ReportingSide.ReportingSideBuilder reportingSide;

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide.ReportingSideBuilder getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.reportingSide != null ? this.reportingSide : (this.reportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public CollateralReportInstructionBuilder setCollateralDetails(CollateralDetails _collateralDetails) {
            this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public CollateralReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public CollateralReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
            this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
            return this;
        }

        @Override
        public CollateralReportInstruction build() {
            return new CollateralReportInstructionImpl(this);
        }

        @Override
        public CollateralReportInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralReportInstructionBuilder prune() {
            super.prune();
            if (this.reportingSide != null && !this.reportingSide.prune().hasData()) {
                this.reportingSide = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getReportingSide() != null && this.getReportingSide().hasData();
        }

        @Override
        public CollateralReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CollateralReportInstructionBuilder o = (CollateralReportInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingSide(), (RosettaModelObjectBuilder)o.getReportingSide(), this::setReportingSide);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralReportInstruction _that = (CollateralReportInstruction)this.getType().cast(o);
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralReportInstructionBuilder {reportingSide=" + String.valueOf(this.reportingSide) + "} " + super.toString();
        }
    }

    public static interface CollateralReportInstructionBuilder
    extends CollateralReportInstruction,
    ReportableCollateral.ReportableCollateralBuilder {
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide();

        @Override
        public ReportingSide.ReportingSideBuilder getReportingSide();

        @Override
        public CollateralReportInstructionBuilder setCollateralDetails(CollateralDetails var1);

        @Override
        public CollateralReportInstructionBuilder setReportableInformation(ReportableInformation var1);

        public CollateralReportInstructionBuilder setReportingSide(ReportingSide var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.CollateralDetailsBuilder.class, (RosettaModelObjectBuilder)this.getCollateralDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, (RosettaModelObjectBuilder)this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, this.getReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public CollateralReportInstructionBuilder prune();
    }

    public static class CollateralReportInstructionImpl
    extends ReportableCollateral.ReportableCollateralImpl
    implements CollateralReportInstruction {
        private final ReportingSide reportingSide;

        protected CollateralReportInstructionImpl(CollateralReportInstructionBuilder builder) {
            super(builder);
            this.reportingSide = Optional.ofNullable(builder.getReportingSide()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public CollateralReportInstruction build() {
            return this;
        }

        @Override
        public CollateralReportInstructionBuilder toBuilder() {
            CollateralReportInstructionBuilder builder = CollateralReportInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralReportInstructionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportingSide()).ifPresent(builder::setReportingSide);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollateralReportInstruction _that = (CollateralReportInstruction)this.getType().cast(o);
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CollateralReportInstruction {reportingSide=" + String.valueOf(this.reportingSide) + "} " + super.toString();
        }
    }
}

