/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.basket.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetQuantityForConstituentDefault.class)
public abstract class GetQuantityForConstituent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public NonNegativeQuantitySchedule evaluate(Product constituent, List<? extends TradeLot> tradeLots) {
        NonNegativeQuantitySchedule result;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder resultBuilder = this.doEvaluate(constituent, tradeLots);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product var1, List<? extends TradeLot> var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> predicates(Product var1, List<? extends TradeLot> var2);

    public static class GetQuantityForConstituentDefault
    extends GetQuantityForConstituent {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(Product constituent, List<? extends TradeLot> tradeLots) {
            if (tradeLots == null) {
                tradeLots = Collections.emptyList();
            }
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(result, constituent, tradeLots);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder result, Product constituent, List<? extends TradeLot> tradeLots) {
            MapperC thenArg0 = MapperC.of(tradeLots).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable()).mapC("getProductIdentifier", observable -> observable.getProductIdentifier()).map("Type coercion", fieldWithMetaProductIdentifier -> fieldWithMetaProductIdentifier.getValue()), (Mapper)this.predicates(constituent, tradeLots).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), (CardinalityOperator)CardinalityOperator.All).get());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> item.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
            FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = (FieldWithMetaNonNegativeQuantitySchedule)MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg1.flattenList().get())).get();
            result = fieldWithMetaNonNegativeQuantitySchedule == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)fieldWithMetaNonNegativeQuantitySchedule.getValue());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> predicates(Product constituent, List<? extends TradeLot> tradeLots) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)constituent).map("getSecurity", product -> product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)constituent).map("getSecurity", product -> product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)constituent).map("getLoan", product -> product.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)constituent).map("getLoan", product -> product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)constituent).map("getCommodity", product -> product.getCommodity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)constituent).map("getCommodity", product -> product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)constituent).map("getIndex", product -> product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)constituent).map("getIndex", product -> product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier());
            }
            return MapperC.ofNull();
        }
    }
}

