/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.index.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.standards.iosco.cde.base.price.functions.FormatToMax5Number;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=SeriesRuleDefault.class)
public abstract class SeriesRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FormatToMax5Number formatToMax5Number;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class SeriesRuleDefault
    extends SeriesRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)this.productForEvent.evaluate(input));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
                }
                return MapperS.ofNull();
            });
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).map("getIndexSeries", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexSeries()));
            Integer integer = (Integer)thenArg2.get();
            output = (BigDecimal)MapperS.of((Object)this.formatToMax5Number.evaluate(integer == null ? null : BigDecimal.valueOf(integer.intValue()))).get();
            return output;
        }
    }
}

