/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CommonAssetClass;
import drr.standards.iosco.cde.base.payment.OtherPayment;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.PaymentType4Code;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=OtherPaymentType_02A_ValidationDefault.class)
public abstract class OtherPaymentType_02A_Validation
implements RosettaFunction {
    public Boolean evaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment, BigDecimal fixedRateLeg1, BigDecimal fixedRateLeg2, PriceFormat spreadLeg1, PriceFormat spreadLeg2) {
        Boolean result = this.doEvaluate(actionType, assetClass, otherPayment, fixedRateLeg1, fixedRateLeg2, spreadLeg1, spreadLeg2);
        return result;
    }

    protected abstract Boolean doEvaluate(ActionTypeEnum var1, CommonAssetClass var2, List<? extends OtherPayment> var3, BigDecimal var4, BigDecimal var5, PriceFormat var6, PriceFormat var7);

    public static class OtherPaymentType_02A_ValidationDefault
    extends OtherPaymentType_02A_Validation {
        @Override
        protected Boolean doEvaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment, BigDecimal fixedRateLeg1, BigDecimal fixedRateLeg2, PriceFormat spreadLeg1, PriceFormat spreadLeg2) {
            if (otherPayment == null) {
                otherPayment = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, actionType, assetClass, otherPayment, fixedRateLeg1, fixedRateLeg2, spreadLeg1, spreadLeg2);
        }

        protected Boolean assignOutput(Boolean result, ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment, BigDecimal fixedRateLeg1, BigDecimal fixedRateLeg2, PriceFormat spreadLeg1, PriceFormat spreadLeg2) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)((Object)actionType)), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CRDT)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)actionType)), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)fixedRateLeg1))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)fixedRateLeg2))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)spreadLeg1))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)spreadLeg2))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()), (Mapper)MapperS.of((Object)((Object)PaymentType4Code.UFRO)), (CardinalityOperator)CardinalityOperator.Any).get() : (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getAmount", _otherPayment -> _otherPayment.getAmount()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getCurrency", _otherPayment -> _otherPayment.getCurrency()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getCurrency", _otherPayment -> _otherPayment.getCurrency()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getDate", _otherPayment -> _otherPayment.getDate()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPayer", _otherPayment -> _otherPayment.getPayer()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getReceiver", _otherPayment -> _otherPayment.getReceiver()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? Boolean.valueOf(false) : null)) : null;
            return result;
        }
    }
}

