/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.FCAPartyInformation;
import drr.regulation.common.NatureOfPartyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FCAPartyInformationFinancialNonFinancial")
@ImplementedBy(value=Default.class)
public interface FCAPartyInformationFinancialNonFinancial
extends Validator<FCAPartyInformation> {
    public static final String NAME = "FCAPartyInformationFinancialNonFinancial";
    public static final String DEFINITION = "if natureOfParty = NatureOfPartyEnum -> Financial then corporateSector -> financialSector exists else if natureOfParty = NatureOfPartyEnum -> NonFinancial then corporateSector -> nonFinancialSector exists";

    public static class NoOp
    implements FCAPartyInformationFinancialNonFinancial {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAPartyInformation fCAPartyInformation) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FCAPartyInformationFinancialNonFinancial {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAPartyInformation fCAPartyInformation) {
            ComparisonResult result = this.executeDataRule(fCAPartyInformation);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FCAPartyInformationFinancialNonFinancial.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FCAPartyInformation", (RosettaPath)path, (String)FCAPartyInformationFinancialNonFinancial.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FCAPartyInformationFinancialNonFinancial.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FCAPartyInformation", (RosettaPath)path, (String)FCAPartyInformationFinancialNonFinancial.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FCAPartyInformation fCAPartyInformation) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)fCAPartyInformation).map("getNatureOfParty", _fCAPartyInformation -> _fCAPartyInformation.getNatureOfParty()), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)fCAPartyInformation).map("getCorporateSector", _fCAPartyInformation -> _fCAPartyInformation.getCorporateSector()).mapC("getFinancialSector", corporateSector -> corporateSector.getFinancialSector()));
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)fCAPartyInformation).map("getNatureOfParty", _fCAPartyInformation -> _fCAPartyInformation.getNatureOfParty()), (Mapper)MapperS.of((Object)((Object)NatureOfPartyEnum.NON_FINANCIAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)fCAPartyInformation).map("getCorporateSector", _fCAPartyInformation -> _fCAPartyInformation.getCorporateSector()).mapC("getNonFinancialSector", corporateSector -> corporateSector.getNonFinancialSector()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

