/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.csa.rewrite.trade.functions.InterestRateLeg2Basis;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg2CrossCurrencyDefault.class)
public abstract class InterestRateLeg2CrossCurrency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg2Basis interestRateLeg2Basis;
    @Inject
    protected drr.regulation.common.functions.InterestRateLeg2CrossCurrency interestRateLeg2CrossCurrency;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg2;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = this.doEvaluate(product);
        if (interestRateLeg2Builder == null) {
            interestRateLeg2 = null;
        } else {
            interestRateLeg2 = interestRateLeg2Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg2);
        }
        return interestRateLeg2;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> floatingRateLegs(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> fixedRateLegs(Product var1);

    protected abstract MapperS<? extends InterestRatePayout> csaInterestRateLeg2Basis(Product var1);

    protected abstract MapperS<? extends InterestRatePayout> drrInterestRateLeg2CrossCurrency(Product var1);

    public static class InterestRateLeg2CrossCurrencyDefault
    extends InterestRateLeg2CrossCurrency {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg2, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
            interestRateLeg2 = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.floatingRateLegs(product).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.floatingRateLegs(product).get()) : (ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.floatingRateLegs(product).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.csaInterestRateLeg2Basis(product).get()) : (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.drrInterestRateLeg2CrossCurrency(product).get()));
            return Optional.ofNullable(interestRateLeg2).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> floatingRateLegs(Product product) {
            return this.interestRatePayouts(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).get());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> fixedRateLegs(Product product) {
            return this.interestRatePayouts(product).filterItemNullSafe(leg -> ExpressionOperatorsNullSafe.exists((Mapper)leg.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
        }

        @Override
        protected MapperS<? extends InterestRatePayout> csaInterestRateLeg2Basis(Product product) {
            return MapperS.of((Object)this.interestRateLeg2Basis.evaluate(product));
        }

        @Override
        protected MapperS<? extends InterestRatePayout> drrInterestRateLeg2CrossCurrency(Product product) {
            return MapperS.of((Object)this.interestRateLeg2CrossCurrency.evaluate(product));
        }
    }
}

