/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PartyLeiAndPersonByRoles;
import drr.regulation.csa.rewrite.trade.reports.IsCSAAlignedRule;
import drr.standards.iosco.cde.version3.party.reports.Direction2PayerPartyLeg1Rule;
import drr.standards.iosco.cde.version3.party.reports.Direction2PayerPartyLeg2Rule;
import javax.inject.Inject;

@ImplementedBy(value=PayerIdentifierLeg2RuleDefault.class)
public abstract class PayerIdentifierLeg2Rule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Direction2PayerPartyLeg1Rule direction2PayerPartyLeg1Rule;
    @Inject
    protected Direction2PayerPartyLeg2Rule direction2PayerPartyLeg2Rule;
    @Inject
    protected IsCSAAlignedRule isCSAAlignedRule;
    @Inject
    protected PartyLeiAndPersonByRoles partyLeiAndPersonByRoles;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PayerIdentifierLeg2RuleDefault
    extends PayerIdentifierLeg2Rule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isCSAAlignedRule.evaluate(input)), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ReferenceWithMetaParty referenceWithMetaParty0 = (ReferenceWithMetaParty)MapperS.of((Object)input).map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
                output = this.partyLeiAndPersonByRoles.evaluate(this.direction2PayerPartyLeg2Rule.evaluate(input), referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue());
            } else {
                ReferenceWithMetaParty referenceWithMetaParty1 = (ReferenceWithMetaParty)MapperS.of((Object)input).map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
                output = this.partyLeiAndPersonByRoles.evaluate(this.direction2PayerPartyLeg1Rule.evaluate(input), referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue());
            }
            return output;
        }
    }
}

