/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.SupervisoryBodyForCSA;
import drr.standards.iosco.cde.version3.event.reports.ActionTypeRule;
import drr.standards.iosco.cde.version3.event.reports.EventTypeRule;
import drr.standards.iosco.cde.version3.execution.reports.CentralCounterpartyRule;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import javax.inject.Inject;

@ImplementedBy(value=PlatformAnonymousExecutionIndicatorRuleDefault.class)
public abstract class PlatformAnonymousExecutionIndicatorRule
implements ReportFunction<TransactionReportInstruction, Boolean> {
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected CentralCounterpartyRule centralCounterpartyRule;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected SupervisoryBodyForCSA supervisoryBodyForCSA;

    public Boolean evaluate(TransactionReportInstruction input) {
        Boolean output = this.doEvaluate(input);
        return output;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    public static class PlatformAnonymousExecutionIndicatorRuleDefault
    extends PlatformAnonymousExecutionIndicatorRule {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction input) {
            Boolean output = null;
            return this.assignOutput(output, input);
        }

        protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
            MapperS ifThenElseResult;
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEvent)item.get()));
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.actionTypeRule.evaluate((TransactionReportInstruction)thenArg0.get()))), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)EventTypeEnum.CLRG)), MapperS.of((Object)((Object)EventTypeEnum.CLAL))}), (Mapper)MapperS.of((Object)((Object)this.eventTypeRule.evaluate((TransactionReportInstruction)thenArg0.get()))), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.centralCounterpartyRule.evaluate((TransactionReportInstruction)thenArg0.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult = MapperS.of((Object)((Boolean)thenArg0.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).map("getSefOrDcmAnonymousIndicator", reportableInformation -> reportableInformation.getSefOrDcmAnonymousIndicator()).getOrDefault((Object)false)));
            } else {
                MapperS thenArg1 = thenArg0.mapSingleToItem(item -> item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
                ifThenElseResult = thenArg1.mapSingleToItem(item -> {
                    MapperC thenArg = item.mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).filterItemNullSafe(_item -> ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of(this.supervisoryBodyForCSA.evaluate()), (Mapper)_item.mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), (CardinalityOperator)CardinalityOperator.Any).get());
                    if (ComparisonResult.ofNullSafe((Mapper)ExpressionOperatorsNullSafe.exists((Mapper)thenArg).asMapper()).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ExecutionVenueTypeEnum.SEF)), MapperS.of((Object)((Object)ExecutionVenueTypeEnum.DCM))}), (Mapper)item.map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return MapperS.of((Object)((Boolean)item.map("getSefOrDcmAnonymousIndicator", reportableInformation -> reportableInformation.getSefOrDcmAnonymousIndicator()).getOrDefault((Object)false)));
                    }
                    return MapperS.ofNull();
                });
            }
            output = (Boolean)ifThenElseResult.get();
            return output;
        }
    }
}

