/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportCSA_VR_0144_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportCSA_VR_0144_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportCSA_VR_0144_01";
    public static final String DEFINITION = "if nonReportable -> postUpiData -> Header -> InstrumentType = Option or nonReportable -> instrumentType = Option then optionPremiumAmount exists else optionPremiumAmount is absent";

    public static class NoOp
    implements CSATransactionReportCSA_VR_0144_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportCSA_VR_0144_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportCSA_VR_0144_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0144_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportCSA_VR_0144_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportCSA_VR_0144_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getNonReportable", _cSATransactionReport -> _cSATransactionReport.getNonReportable()).map("getInstrumentType", cSANonReportable -> cSANonReportable.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getOptionPremiumAmount", _cSATransactionReport -> _cSATransactionReport.getOptionPremiumAmount()));
                }
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReport).map("getOptionPremiumAmount", _cSATransactionReport -> _cSATransactionReport.getOptionPremiumAmount()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

