/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.lei.LeiCategoryEnum;
import drr.enrichment.lei.functions.API_GetLeiData;
import drr.regulation.esma.emir.refit.margin.ESMAEMIRMarginReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRMarginReportEMIR_VR_3006_03")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRMarginReportEMIR_VR_3006_03
extends Validator<ESMAEMIRMarginReport> {
    public static final String NAME = "ESMAEMIRMarginReportEMIR_VR_3006_03";
    public static final String DEFINITION = "if partiesToTheDerivative -> counterparty2IdentifierType = True then (API_GetLeiData(partiesToTheDerivative -> counterparty2) -> entityStatus exists and API_GetLeiData(partiesToTheDerivative -> counterparty2) -> entityCategory <> LeiCategoryEnum -> Branch)";

    public static class NoOp
    implements ESMAEMIRMarginReportEMIR_VR_3006_03 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport eSMAEMIRMarginReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRMarginReportEMIR_VR_3006_03 {
        @Inject
        protected API_GetLeiData aPI_GetLeiData;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRMarginReport eSMAEMIRMarginReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRMarginReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRMarginReportEMIR_VR_3006_03.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRMarginReport", (RosettaPath)path, (String)ESMAEMIRMarginReportEMIR_VR_3006_03.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRMarginReportEMIR_VR_3006_03.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRMarginReport", (RosettaPath)path, (String)ESMAEMIRMarginReportEMIR_VR_3006_03.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRMarginReport eSMAEMIRMarginReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)eSMAEMIRMarginReport).map("getPartiesToTheDerivative", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getPartiesToTheDerivative()).map("getCounterparty2IdentifierType", partiesToTheDerivative -> partiesToTheDerivative.getCounterparty2IdentifierType()), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.aPI_GetLeiData.evaluate((String)MapperS.of((Object)eSMAEMIRMarginReport).map("getPartiesToTheDerivative", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getPartiesToTheDerivative()).map("getCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getCounterparty2()).get())).map("getEntityStatus", leiData -> leiData.getEntityStatus())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)this.aPI_GetLeiData.evaluate((String)MapperS.of((Object)eSMAEMIRMarginReport).map("getPartiesToTheDerivative", _eSMAEMIRMarginReport -> _eSMAEMIRMarginReport.getPartiesToTheDerivative()).map("getCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getCounterparty2()).get())).map("getEntityCategory", leiData -> leiData.getEntityCategory()), (Mapper)MapperS.of((Object)((Object)LeiCategoryEnum.BRANCH)), (CardinalityOperator)CardinalityOperator.Any));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

