/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.esma.emir.refit.trade.reports.SpreadOfLeg1NotationRule;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg1Rule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SpreadofLeg1RuleDefault.class)
public abstract class SpreadofLeg1Rule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetNameOfTheFloatingRateOfLeg1 getNameOfTheFloatingRateOfLeg1;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected SpreadLeg1Rule spreadLeg1Rule;
    @Inject
    protected SpreadOfLeg1NotationRule spreadOfLeg1NotationRule;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class SpreadofLeg1RuleDefault
    extends SpreadofLeg1Rule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> {
                PriceSchedule priceSchedule = this.spreadLeg1Rule.evaluate((TransactionReportInstruction)item.get());
                if ((priceSchedule == null ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.ofNull()).getOrDefault(Boolean.valueOf(false)) : ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(Boolean.valueOf(false))).booleanValue()) {
                    return MapperS.of((Object)this.priceFormatFromNotation.evaluate((BigDecimal)MapperS.of((Object)this.spreadLeg1Rule.evaluate((TransactionReportInstruction)item.get())).map("getValue", _priceSchedule -> _priceSchedule.getValue()).get(), this.spreadOfLeg1NotationRule.evaluate((TransactionReportInstruction)item.get())));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.getNameOfTheFloatingRateOfLeg1.evaluate((ReportableEvent)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)PriceFormat.builder().setBasis(BigDecimal.valueOf(0L)).build());
                }
                return MapperS.ofNull();
            }).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

