/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsESMAThirdCountryEquivalentMarket;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.MicMarketCategoryEnum;
import drr.standards.iso.functions.GetOrFetchMicData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_1003_01")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_1003_01
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_1003_01";
    public static final String DEFINITION = "if (GetOrFetchMicData(nonReportable -> enrichment -> micData, venueOfExecution) extract marketCategory = MicMarketCategoryEnum -> RMKT or IsESMAThirdCountryEquivalentMarket(mic) = True) then entityResponsibleForReporting is absent else entityResponsibleForReporting exists";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_1003_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_1003_01 {
        @Inject
        protected GetOrFetchMicData getOrFetchMicData;
        @Inject
        protected IsESMAThirdCountryEquivalentMarket isESMAThirdCountryEquivalentMarket;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_1003_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1003_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_1003_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_1003_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                if (((Boolean)MapperS.of((Object)this.getOrFetchMicData.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getNonReportable", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNonReportable()).map("getEnrichment", nonReportable -> nonReportable.getEnrichment()).mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getVenueOfExecution", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getVenueOfExecution()).get())).mapSingleToItem(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getMarketCategory", micData -> micData.getMarketCategory()), (Mapper)MapperS.of((Object)((Object)MicMarketCategoryEnum.RMKT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isESMAThirdCountryEquivalentMarket.evaluate((String)item.map("getMic", micData -> micData.getMic()).get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).asMapper()).getOrDefault((Object)false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEntityResponsibleForReporting", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEntityResponsibleForReporting()));
                }
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getEntityResponsibleForReporting", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEntityResponsibleForReporting()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

