/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeEROR;
import drr.regulation.common.functions.IsActionTypePRTO;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import javax.inject.Inject;

@ImplementedBy(value=AssetClassRuleDefault.class)
public abstract class AssetClassRule
implements ReportFunction<TransactionReportInstruction, CommonAssetClass> {
    @Inject
    protected drr.regulation.common.trade.contract.reports.AssetClassRule assetClassRule;
    @Inject
    protected IsActionTypeEROR isActionTypeEROR;
    @Inject
    protected IsActionTypePRTO isActionTypePRTO;
    @Inject
    protected IsActionTypeTERM isActionTypeTERM;
    @Inject
    protected IsAllowableActionForHKMA isAllowableActionForHKMA;

    public CommonAssetClass evaluate(TransactionReportInstruction input) {
        CommonAssetClass output = this.doEvaluate(input);
        return output;
    }

    protected abstract CommonAssetClass doEvaluate(TransactionReportInstruction var1);

    public static class AssetClassRuleDefault
    extends AssetClassRule {
        @Override
        protected CommonAssetClass doEvaluate(TransactionReportInstruction input) {
            CommonAssetClass output = null;
            return this.assignOutput(output, input);
        }

        protected CommonAssetClass assignOutput(CommonAssetClass output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isAllowableActionForHKMA.evaluate((ReportableEvent)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypeEROR.evaluate((ReportableEvent)item.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypePRTO.evaluate((ReportableEvent)item.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypeTERM.evaluate((ReportableEvent)item.get())))).get());
            output = (CommonAssetClass)((Object)MapperS.of((Object)((Object)this.assetClassRule.evaluate((ReportableEvent)thenArg.get()))).get());
            return output;
        }
    }
}

