/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade;

import cdm.base.staticdata.party.Address;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.mas.rewrite.trade.meta.TraderMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Trader", builder=TraderBuilderImpl.class, version="6.21.2")
@RuneDataType(value="Trader", model="drr", builder=TraderBuilderImpl.class, version="6.21.2")
public interface Trader
extends RosettaModelObject {
    public static final TraderMeta metaData = new TraderMeta();

    public String getName();

    public Address getPlaceOfEmployment();

    public Boolean getIsAuthorisedToTradeInSingapore();

    public Address getCurrentLocation();

    public Trader build();

    public TraderBuilder toBuilder();

    public static TraderBuilder builder() {
        return new TraderBuilderImpl();
    }

    default public RosettaMetaData<? extends Trader> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Trader> getType() {
        return Trader.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("placeOfEmployment"), processor, Address.class, (RosettaModelObject)this.getPlaceOfEmployment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isAuthorisedToTradeInSingapore"), Boolean.class, (Object)this.getIsAuthorisedToTradeInSingapore(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currentLocation"), processor, Address.class, (RosettaModelObject)this.getCurrentLocation(), new AttributeMeta[0]);
    }

    public static class TraderBuilderImpl
    implements TraderBuilder {
        protected String name;
        protected Address.AddressBuilder placeOfEmployment;
        protected Boolean isAuthorisedToTradeInSingapore;
        protected Address.AddressBuilder currentLocation;

        @Override
        @RosettaAttribute(value="name", isRequired=true)
        @RuneAttribute(value="name", isRequired=true)
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="placeOfEmployment", isRequired=true)
        @RuneAttribute(value="placeOfEmployment", isRequired=true)
        public Address.AddressBuilder getPlaceOfEmployment() {
            return this.placeOfEmployment;
        }

        @Override
        public Address.AddressBuilder getOrCreatePlaceOfEmployment() {
            Address.AddressBuilder result = this.placeOfEmployment != null ? this.placeOfEmployment : (this.placeOfEmployment = Address.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="isAuthorisedToTradeInSingapore", isRequired=true)
        @RuneAttribute(value="isAuthorisedToTradeInSingapore", isRequired=true)
        public Boolean getIsAuthorisedToTradeInSingapore() {
            return this.isAuthorisedToTradeInSingapore;
        }

        @Override
        @RosettaAttribute(value="currentLocation", isRequired=true)
        @RuneAttribute(value="currentLocation", isRequired=true)
        public Address.AddressBuilder getCurrentLocation() {
            return this.currentLocation;
        }

        @Override
        public Address.AddressBuilder getOrCreateCurrentLocation() {
            Address.AddressBuilder result = this.currentLocation != null ? this.currentLocation : (this.currentLocation = Address.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="name", isRequired=true)
        @RuneAttribute(value="name", isRequired=true)
        public TraderBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="placeOfEmployment", isRequired=true)
        @RuneAttribute(value="placeOfEmployment", isRequired=true)
        public TraderBuilder setPlaceOfEmployment(Address _placeOfEmployment) {
            this.placeOfEmployment = _placeOfEmployment == null ? null : _placeOfEmployment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isAuthorisedToTradeInSingapore", isRequired=true)
        @RuneAttribute(value="isAuthorisedToTradeInSingapore", isRequired=true)
        public TraderBuilder setIsAuthorisedToTradeInSingapore(Boolean _isAuthorisedToTradeInSingapore) {
            this.isAuthorisedToTradeInSingapore = _isAuthorisedToTradeInSingapore == null ? null : _isAuthorisedToTradeInSingapore;
            return this;
        }

        @Override
        @RosettaAttribute(value="currentLocation", isRequired=true)
        @RuneAttribute(value="currentLocation", isRequired=true)
        public TraderBuilder setCurrentLocation(Address _currentLocation) {
            this.currentLocation = _currentLocation == null ? null : _currentLocation.toBuilder();
            return this;
        }

        @Override
        public Trader build() {
            return new TraderImpl(this);
        }

        @Override
        public TraderBuilder toBuilder() {
            return this;
        }

        @Override
        public TraderBuilder prune() {
            if (this.placeOfEmployment != null && !this.placeOfEmployment.prune().hasData()) {
                this.placeOfEmployment = null;
            }
            if (this.currentLocation != null && !this.currentLocation.prune().hasData()) {
                this.currentLocation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getPlaceOfEmployment() != null && this.getPlaceOfEmployment().hasData()) {
                return true;
            }
            if (this.getIsAuthorisedToTradeInSingapore() != null) {
                return true;
            }
            return this.getCurrentLocation() != null && this.getCurrentLocation().hasData();
        }

        public TraderBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TraderBuilder o = (TraderBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPlaceOfEmployment(), (RosettaModelObjectBuilder)o.getPlaceOfEmployment(), this::setPlaceOfEmployment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrentLocation(), (RosettaModelObjectBuilder)o.getCurrentLocation(), this::setCurrentLocation);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsAuthorisedToTradeInSingapore(), (Object)o.getIsAuthorisedToTradeInSingapore(), this::setIsAuthorisedToTradeInSingapore, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trader _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.placeOfEmployment, _that.getPlaceOfEmployment())) {
                return false;
            }
            if (!Objects.equals(this.isAuthorisedToTradeInSingapore, _that.getIsAuthorisedToTradeInSingapore())) {
                return false;
            }
            return Objects.equals(this.currentLocation, _that.getCurrentLocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.placeOfEmployment != null ? this.placeOfEmployment.hashCode() : 0);
            _result = 31 * _result + (this.isAuthorisedToTradeInSingapore != null ? this.isAuthorisedToTradeInSingapore.hashCode() : 0);
            _result = 31 * _result + (this.currentLocation != null ? this.currentLocation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TraderBuilder {name=" + this.name + ", placeOfEmployment=" + String.valueOf(this.placeOfEmployment) + ", isAuthorisedToTradeInSingapore=" + this.isAuthorisedToTradeInSingapore + ", currentLocation=" + String.valueOf(this.currentLocation) + "}";
        }
    }

    public static interface TraderBuilder
    extends Trader,
    RosettaModelObjectBuilder {
        public Address.AddressBuilder getOrCreatePlaceOfEmployment();

        public Address.AddressBuilder getPlaceOfEmployment();

        public Address.AddressBuilder getOrCreateCurrentLocation();

        public Address.AddressBuilder getCurrentLocation();

        public TraderBuilder setName(String var1);

        public TraderBuilder setPlaceOfEmployment(Address var1);

        public TraderBuilder setIsAuthorisedToTradeInSingapore(Boolean var1);

        public TraderBuilder setCurrentLocation(Address var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("placeOfEmployment"), processor, Address.AddressBuilder.class, (RosettaModelObjectBuilder)this.getPlaceOfEmployment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isAuthorisedToTradeInSingapore"), Boolean.class, (Object)this.getIsAuthorisedToTradeInSingapore(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currentLocation"), processor, Address.AddressBuilder.class, (RosettaModelObjectBuilder)this.getCurrentLocation(), new AttributeMeta[0]);
        }

        public TraderBuilder prune();
    }

    public static class TraderImpl
    implements Trader {
        private final String name;
        private final Address placeOfEmployment;
        private final Boolean isAuthorisedToTradeInSingapore;
        private final Address currentLocation;

        protected TraderImpl(TraderBuilder builder) {
            this.name = builder.getName();
            this.placeOfEmployment = Optional.ofNullable(builder.getPlaceOfEmployment()).map(f -> f.build()).orElse(null);
            this.isAuthorisedToTradeInSingapore = builder.getIsAuthorisedToTradeInSingapore();
            this.currentLocation = Optional.ofNullable(builder.getCurrentLocation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="name", isRequired=true)
        @RuneAttribute(value="name", isRequired=true)
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="placeOfEmployment", isRequired=true)
        @RuneAttribute(value="placeOfEmployment", isRequired=true)
        public Address getPlaceOfEmployment() {
            return this.placeOfEmployment;
        }

        @Override
        @RosettaAttribute(value="isAuthorisedToTradeInSingapore", isRequired=true)
        @RuneAttribute(value="isAuthorisedToTradeInSingapore", isRequired=true)
        public Boolean getIsAuthorisedToTradeInSingapore() {
            return this.isAuthorisedToTradeInSingapore;
        }

        @Override
        @RosettaAttribute(value="currentLocation", isRequired=true)
        @RuneAttribute(value="currentLocation", isRequired=true)
        public Address getCurrentLocation() {
            return this.currentLocation;
        }

        @Override
        public Trader build() {
            return this;
        }

        @Override
        public TraderBuilder toBuilder() {
            TraderBuilder builder = Trader.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TraderBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getPlaceOfEmployment()).ifPresent(builder::setPlaceOfEmployment);
            Optional.ofNullable(this.getIsAuthorisedToTradeInSingapore()).ifPresent(builder::setIsAuthorisedToTradeInSingapore);
            Optional.ofNullable(this.getCurrentLocation()).ifPresent(builder::setCurrentLocation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trader _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.placeOfEmployment, _that.getPlaceOfEmployment())) {
                return false;
            }
            if (!Objects.equals(this.isAuthorisedToTradeInSingapore, _that.getIsAuthorisedToTradeInSingapore())) {
                return false;
            }
            return Objects.equals(this.currentLocation, _that.getCurrentLocation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.placeOfEmployment != null ? this.placeOfEmployment.hashCode() : 0);
            _result = 31 * _result + (this.isAuthorisedToTradeInSingapore != null ? this.isAuthorisedToTradeInSingapore.hashCode() : 0);
            _result = 31 * _result + (this.currentLocation != null ? this.currentLocation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Trader {name=" + this.name + ", placeOfEmployment=" + String.valueOf(this.placeOfEmployment) + ", isAuthorisedToTradeInSingapore=" + this.isAuthorisedToTradeInSingapore + ", currentLocation=" + String.valueOf(this.currentLocation) + "}";
        }
    }
}

