/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.base.price.functions;

import cdm.observable.asset.PriceSchedule;
import cdm.product.template.CalculationSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.base.price.PricePeriod;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableSchedulePeriodDefault.class)
public abstract class GetReportableSchedulePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public List<? extends PricePeriod> evaluate(PriceSchedule priceSchedule, CalculationSchedule calculationSchedule, PriceNotationEnum notation) {
        List pricePeriod;
        List<PricePeriod.PricePeriodBuilder> pricePeriodBuilder = this.doEvaluate(priceSchedule, calculationSchedule, notation);
        if (pricePeriodBuilder == null) {
            pricePeriod = null;
        } else {
            pricePeriod = pricePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, pricePeriod);
        }
        return pricePeriod;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(PriceSchedule var1, CalculationSchedule var2, PriceNotationEnum var3);

    public static class GetReportableSchedulePeriodDefault
    extends GetReportableSchedulePeriod {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(PriceSchedule priceSchedule, CalculationSchedule calculationSchedule, PriceNotationEnum notation) {
            ArrayList<PricePeriod.PricePeriodBuilder> pricePeriod = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(pricePeriod, priceSchedule, calculationSchedule, notation);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> pricePeriod, PriceSchedule priceSchedule, CalculationSchedule calculationSchedule, PriceNotationEnum notation) {
            MapperC thenArg = MapperS.of((Object)priceSchedule).mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue()).mapItem(priceSchedulePeriod -> {
                MapperC thenArg0 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)calculationSchedule)).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)calculationSchedule).mapC("getSchedulePeriod", _calculationSchedule -> _calculationSchedule.getSchedulePeriod()).filterItemNullSafe(customPeriod -> ExpressionOperatorsNullSafe.areEqual((Mapper)priceSchedulePeriod.map("getDate", datedValue -> datedValue.getDate()), (Mapper)customPeriod.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getStartDate", dateRange -> dateRange.getStartDate()), (CardinalityOperator)CardinalityOperator.All).get()) : MapperC.ofNull();
                MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()));
                return MapperS.of((Object)PricePeriod.builder().setPrice(this.priceFormatFromNotation.evaluate((BigDecimal)priceSchedulePeriod.map("getValue", datedValue -> datedValue.getValue()).get(), notation)).setEffectiveDate((Date)priceSchedulePeriod.map("getDate", datedValue -> datedValue.getDate()).get()).setEndDate((Date)MapperS.of((Object)((Date)thenArg1.get())).get()).build());
            });
            pricePeriod.addAll(this.toBuilder(thenArg.sort(item -> item.map("getEffectiveDate", _pricePeriod -> _pricePeriod.getEffectiveDate())).getMulti()));
            return Optional.ofNullable(pricePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

