/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.GetPackageInformation;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version1.price.reports.PackageTransactionSpreadNotationEnumRule;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionSpreadCurrencyRuleDefault.class)
public abstract class PackageTransactionSpreadCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected GetPackageInformation getPackageInformation;
    @Inject
    protected PackageTransactionSpreadNotationEnumRule packageTransactionSpreadNotationEnumRule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionSpreadCurrencyRuleDefault
    extends PackageTransactionSpreadCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg1;
            if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)((Object)this.packageTransactionSpreadNotationEnumRule.evaluate(input))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.BASIS)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperS thenArg0 = MapperS.of((Object)this.getPackageInformation.evaluate(input)).map("getPrice", identifiedList -> identifiedList.getPrice());
                thenArg1 = thenArg0.mapSingleToItem(item -> {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getArithmeticOperator", price -> price.getArithmeticOperator()), (Mapper)MapperS.of((Object)ArithmeticOperationEnum.ADD), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getUnit", price -> price.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                    }
                    return MapperS.ofNull();
                });
            } else {
                thenArg1 = MapperS.ofNull();
            }
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

