/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.price.functions.PriceOfEvent;
import drr.standards.iosco.cde.base.price.functions.PriceOfZeroCouponSwaps;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PriceNoFormatRuleDefault.class)
public abstract class PriceNoFormatRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected PriceOfEvent priceOfEvent;
    @Inject
    protected PriceOfZeroCouponSwaps priceOfZeroCouponSwaps;
    @Inject
    protected ProductForEvent productForEvent;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class PriceNoFormatRuleDefault
    extends PriceNoFormatRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            Boolean _boolean = this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(this.productForEvent.evaluate(input));
            if (_boolean != null && _boolean.booleanValue()) {
                MapperC thenArg0 = MapperC.of(this.priceOfZeroCouponSwaps.evaluate(input));
                MapperC thenArg1 = thenArg0.mapItem(item -> item.map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()));
                output = (BigDecimal)MapperS.of((Object)((BigDecimal)thenArg1.get())).get();
            } else {
                output = this.priceOfEvent.evaluate(input);
            }
            return output;
        }
    }
}

