/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.GetPriceNotation;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version1.price.reports.SpreadLeg2Rule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadLeg2CurrencyRuleDefault.class)
public abstract class SpreadLeg2CurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected GetPriceNotation getPriceNotation;
    @Inject
    protected SpreadLeg2Rule spreadLeg2Rule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadLeg2CurrencyRuleDefault
    extends SpreadLeg2CurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            PriceSchedule priceSchedule = this.spreadLeg2Rule.evaluate(input);
            MapperS thenArg0 = priceSchedule == null ? MapperS.ofNull() : MapperS.of((Object)ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = (ReferenceWithMetaPriceSchedule)item.get();
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.getPriceNotation.evaluate(referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).map("getUnit", _priceSchedule -> _priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                }
                return MapperS.ofNull();
            });
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

