/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.PayoutLegWithAuxiliary;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountFormatDefault.class)
public abstract class NotionalAmountFormat
implements RosettaFunction {
    @Inject
    protected drr.standards.iosco.cde.version1.quantity.functions.NotionalAmountFormat notionalAmountFormat;

    public BigDecimal evaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
        BigDecimal notionalAmount = this.doEvaluate(payout, defaultValue);
        return notionalAmount;
    }

    protected abstract BigDecimal doEvaluate(PayoutLegWithAuxiliary var1, BigDecimal var2);

    public static class NotionalAmountFormatDefault
    extends NotionalAmountFormat {
        @Override
        protected BigDecimal doEvaluate(PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
            BigDecimal notionalAmount = null;
            return this.assignOutput(notionalAmount, payout, defaultValue);
        }

        protected BigDecimal assignOutput(BigDecimal notionalAmount, PayoutLegWithAuxiliary payout, BigDecimal defaultValue) {
            notionalAmount = this.notionalAmountFormat.evaluate(payout, defaultValue);
            return notionalAmount;
        }
    }
}

