/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.MetaBeans;
import org.joda.beans.MetaProperty;

public interface MetaBean {
    public static MetaBean of(Class<?> cls) {
        return MetaBeans.lookup(cls);
    }

    public static void register(MetaBean metaBean) {
        MetaBeans.register(metaBean);
    }

    public boolean isBuildable();

    public BeanBuilder<? extends Bean> builder();

    default public String beanName() {
        return this.beanType().getName();
    }

    public Class<? extends Bean> beanType();

    default public int metaPropertyCount() {
        return this.metaPropertyMap().size();
    }

    default public boolean metaPropertyExists(String propertyName) {
        return this.metaPropertyMap().containsKey(propertyName);
    }

    default public <R> MetaProperty<R> metaProperty(String propertyName) {
        MetaProperty<?> mp = this.metaPropertyMap().get(propertyName);
        if (mp == null) {
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }
        return mp;
    }

    default public Iterable<MetaProperty<?>> metaPropertyIterable() {
        return this.metaPropertyMap().values();
    }

    public Map<String, MetaProperty<?>> metaPropertyMap();

    default public List<Annotation> annotations() {
        return Collections.unmodifiableList(Arrays.asList(this.beanType().getAnnotations()));
    }

    default public <A extends Annotation> A annotation(Class<A> annotationClass) {
        List<Annotation> annotations = this.annotations();
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (A)annotation;
        }
        throw new NoSuchElementException("Unknown annotation: " + annotationClass.getName());
    }
}

