/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.beans.ser.DefaultDeserializer;
import org.joda.beans.ser.JodaBeanSer;
import org.joda.beans.ser.LenientDeserializer;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerDeserializerProvider;
import org.joda.beans.ser.SerTypeMapper;

public final class SerDeserializers {
    public static final SerDeserializers INSTANCE = new SerDeserializers(false, new SerDeserializerProvider[0]);
    public static final SerDeserializers LENIENT = new SerDeserializers(true, new SerDeserializerProvider[0]);
    private final boolean lenient;
    private final SerDeserializer defaultDeserializer;
    private final ConcurrentMap<Class<?>, SerDeserializer> deserializers = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<SerDeserializerProvider> providers = new CopyOnWriteArrayList();

    public SerDeserializers() {
        this.lenient = false;
        this.defaultDeserializer = DefaultDeserializer.INSTANCE;
    }

    public SerDeserializers(SerDeserializerProvider ... providers) {
        this.lenient = false;
        this.defaultDeserializer = DefaultDeserializer.INSTANCE;
        this.providers.addAll(Arrays.asList(providers));
    }

    public SerDeserializers(boolean lenient, SerDeserializerProvider ... providers) {
        this.lenient = lenient;
        this.providers.addAll(Arrays.asList(providers));
        this.defaultDeserializer = lenient ? LenientDeserializer.INSTANCE : DefaultDeserializer.INSTANCE;
    }

    public SerDeserializers register(Class<?> type, SerDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    public ConcurrentMap<Class<?>, SerDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public SerDeserializers registerProvider(SerDeserializerProvider provider) {
        this.providers.add(provider);
        return this;
    }

    public SerDeserializer findDeserializer(Class<?> type) {
        SerDeserializer deser = (SerDeserializer)this.deserializers.get(type);
        if (deser != null) {
            return deser;
        }
        for (SerDeserializerProvider provider : this.providers) {
            deser = provider.findDeserializer(type);
            if (deser == null) continue;
            return deser;
        }
        return this.defaultDeserializer;
    }

    public Class<?> decodeType(String typeStr, JodaBeanSer settings, String basePackage, Map<String, Class<?>> knownTypes, Class<?> defaultType) throws ClassNotFoundException {
        if (this.lenient) {
            return SerTypeMapper.decodeType(typeStr, settings, basePackage, knownTypes, defaultType == Object.class ? String.class : defaultType);
        }
        return SerTypeMapper.decodeType(typeStr, settings, basePackage, knownTypes);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

