/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser.bin;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.joda.beans.ser.bin.MsgPackInput;

final class MsgPackVisualizer
extends MsgPackInput {
    private String indent = "";
    private StringBuilder buf = new StringBuilder(1024);

    MsgPackVisualizer(byte[] bytes) {
        super(bytes);
    }

    MsgPackVisualizer(InputStream stream) {
        super(stream);
    }

    MsgPackVisualizer(DataInputStream stream) {
        super(stream);
    }

    String visualizeData() {
        this.readAll();
        return this.buf.toString();
    }

    @Override
    protected void readArrayItem() throws IOException {
        this.indent = this.indent + "- ";
        super.readArrayItem();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void readMapKey() throws IOException {
        this.indent = this.indent + "= ";
        super.readMapKey();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void readMapValue() throws IOException {
        this.indent = this.indent + "  ";
        super.readMapValue();
        this.indent = this.indent.substring(0, this.indent.length() - 2);
    }

    @Override
    protected void handleObjectStart() {
        this.buf.append(this.indent);
        this.indent = this.indent.replace("-", " ").replace("=", " ");
    }

    @Override
    protected void handleBoolean(boolean bool) {
        this.buf.append(bool).append(System.lineSeparator());
    }

    @Override
    protected void handleNil() {
        this.buf.append("nil").append(System.lineSeparator());
    }

    @Override
    protected void handleInt(int value) {
        this.buf.append("int " + value).append(System.lineSeparator());
    }

    @Override
    protected void handleUnsignedLong(long value) {
        this.buf.append("int " + value + " unsigned").append(System.lineSeparator());
    }

    @Override
    protected void handleSignedLong(long value) {
        this.buf.append("int " + value + " signed").append(System.lineSeparator());
    }

    @Override
    protected void handleFloat(float value) {
        this.buf.append("flt " + value).append(System.lineSeparator());
    }

    @Override
    protected void handleDouble(double value) {
        this.buf.append("dbl " + value).append(System.lineSeparator());
    }

    @Override
    protected void handleUnknown(byte b) {
        this.buf.append("Unknown - " + String.format("%02X ", b)).append(System.lineSeparator());
    }

    @Override
    protected void handleString(String str) {
        this.buf.append("str '" + str + '\'').append(System.lineSeparator());
    }

    @Override
    protected void handleArrayHeader(int size) {
        this.buf.append("arr (" + size + ")").append(System.lineSeparator());
    }

    @Override
    protected void handleMapHeader(int size) {
        this.buf.append("map (" + size + ")").append(System.lineSeparator());
    }

    @Override
    protected void handleBinary(byte[] bytes) {
        this.buf.append("bin '");
        for (byte b : bytes) {
            this.buf.append(MsgPackVisualizer.toHex(b));
        }
        this.buf.append("'").append(System.lineSeparator());
    }

    @Override
    protected void handleExtension(int type, byte[] bytes) throws IOException {
        if (type == 32 || type == 33 || type == 34) {
            String str = new String(bytes, UTF_8);
            this.buf.append("ext type=" + type + " '" + str + "'").append(System.lineSeparator());
        } else {
            this.buf.append("ext type=" + type + " '");
            for (byte b : bytes) {
                this.buf.append(MsgPackVisualizer.toHex(b));
            }
            this.buf.append("'").append(System.lineSeparator());
        }
    }
}

