# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.common.settlement.ResolvablePriceQuantity import ResolvablePriceQuantity
from cdm.base.math.NonNegativeQuantitySchedule import NonNegativeQuantitySchedule
from cdm.base.math.UnitType import UnitType
from cdm.product.common.settlement.SettlementDate import SettlementDate
from cdm.base.staticdata.party.PayerReceiver import PayerReceiver
from cdm.product.common.settlement.CashflowType import CashflowType
from cdm.product.common.settlement.PaymentDiscounting import PaymentDiscounting
from cdm.product.common.settlement.Cashflow import Cashflow

__all__ = ['Create_Cashflow']


@replaceable
def Create_Cashflow(amount: Decimal, currency: str, settlementDate: SettlementDate, payerReceiver: PayerReceiver, cashflowType: CashflowType, paymentDiscounting: PaymentDiscounting | None) -> Cashflow:
    """
    
    Parameters 
    ----------
    amount : number
    
    currency : string
    
    settlementDate : SettlementDate
    
    payerReceiver : PayerReceiver
    
    cashflowType : CashflowType
    
    paymentDiscounting : PaymentDiscounting
    
    Returns
    -------
    cashflow : Cashflow
    
    """
    self = inspect.currentframe()
    
    
    cashflow = _get_rosetta_object('Cashflow', 'settlementTerms', _get_rosetta_object('SettlementTerms', 'settlementDate', rosetta_resolve_attr(self, "settlementDate")))
    cashflow = set_rosetta_attr(rosetta_resolve_attr(self, 'cashflow'), 'payerReceiver', rosetta_resolve_attr(self, "payerReceiver"))
    cashflow = set_rosetta_attr(rosetta_resolve_attr(self, 'cashflow'), 'cashflowType', rosetta_resolve_attr(self, "cashflowType"))
    cashflow = set_rosetta_attr(rosetta_resolve_attr(self, 'cashflow'), 'paymentDiscounting', rosetta_resolve_attr(self, "paymentDiscounting"))
    cashflow = set_rosetta_attr(rosetta_resolve_attr(self, 'cashflow'), 'priceQuantity', ResolvablePriceQuantity(quantitySchedule=NonNegativeQuantitySchedule(value=rosetta_resolve_attr(self, "amount"), unit=UnitType(currency=rosetta_resolve_attr(self, "currency")))))
    
    
    return cashflow

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
