# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.template.ContractualProduct import ContractualProduct
from cdm.product.common.settlement.Cashflow import Cashflow
from cdm.event.common.TermsChangeInstruction import TermsChangeInstruction

__all__ = ['Create_CashflowTermsChangeInstruction']


@replaceable
def Create_CashflowTermsChangeInstruction(contractualProduct: ContractualProduct, cashFlow: Cashflow) -> TermsChangeInstruction:
    """
    
    Parameters 
    ----------
    contractualProduct : ContractualProduct
    
    cashFlow : Cashflow
    
    Returns
    -------
    termsChangeInstruction : TermsChangeInstruction
    
    """
    self = inspect.currentframe()
    
    
    termsChangeInstruction = _get_rosetta_object('TermsChangeInstruction', 'product', _get_rosetta_object('Product', 'contractualProduct', rosetta_resolve_attr(self, "contractualProduct")))
    termsChangeInstruction.add_rosetta_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, termsChangeInstruction), 'product'), 'contractualProduct'), 'economicTerms'), 'payout'), 'cashflow'), rosetta_resolve_attr(self, "cashFlow"))
    
    
    return termsChangeInstruction

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
