# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['BondEquityModel']


class BondEquityModel(BaseDataClass):
    _CHOICE_ALIAS_MAP ={"productIdentifier":[("bondchoiceModel", rosetta_resolve_deep_attr), ("equity", rosetta_resolve_attr)]}
    """
     Bond equity model to value convertible bonds and modelled onto BondEquity.model in FpML.
    """
    bondchoiceModel: Optional[cdm.observable.asset.BondChoiceModel.BondChoiceModel] = Field(None, description="Either the bond or convertible bond.")
    """
    Either the bond or convertible bond.
    """
    equity: Optional[cdm.base.staticdata.asset.common.Equity.Equity] = Field(None, description="The equity.")
    """
    The equity.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'bondchoiceModel', 'equity', necessity=True)

import cdm 
import cdm.observable.asset.BondChoiceModel
import cdm.base.staticdata.asset.common.Equity
