# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CleanPrice']


class CleanPrice(BaseDataClass):
    """
     Class to specify the clean price of a bond in a bond valuation model, with accruals presented separately, and modelled onto the cleanPrice model in BonPriceAndYield.model in FpML.
    """
    cleanPrice: Decimal = Field(..., description="The clean price as a number.")
    """
    The clean price as a number.
    """
    accruals: Optional[Decimal] = Field(None, description="The accruals as a number.")
    """
    The accruals as a number.
    """
    dirtyPrice: Optional[str] = Field(None, description="Placeholder for a calculation of dirtyPrice based on cleanPrice and accruals.")
    """
    Placeholder for a calculation of dirtyPrice based on cleanPrice and accruals.
    """

import cdm 
