# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ListingType']


class ListingType(BaseDataClass):
    """
    Specifies a filter based on an underlying corporate financial official listing defined at a stock exchange.
    """
    exchange: Optional[AttributeWithMeta[str] | str] = Field(None, description="Represents a filter based on the Primary Stock Exchange facilitating the listing of companies, exchange of Stocks, Exchange traded Derivatives, Bonds, and other Securities expressed in ISO standard 10383.")
    """
    Represents a filter based on the Primary Stock Exchange facilitating the listing of companies, exchange of Stocks, Exchange traded Derivatives, Bonds, and other Securities expressed in ISO standard 10383.
    """
    sector: Optional[AttributeWithMeta[str] | str] = Field(None, description="Represents a filter based on an industry sector defined under a system for classifying industry types such as Global Industry Classification Standard (GICS) and North American Industry Classification System (NAICS)")
    """
    Represents a filter based on an industry sector defined under a system for classifying industry types such as Global Industry Classification Standard (GICS) and North American Industry Classification System (NAICS)
    """
    index: Optional[cdm.base.staticdata.asset.common.Index.Index] = Field(None, description="Represents a filter based on an index that measures a stock market, or a subset of a stock market.")
    """
    Represents a filter based on an index that measures a stock market, or a subset of a stock market.
    """

import cdm 
import cdm.base.staticdata.asset.common.Index
