# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OptionFeature']


class OptionFeature(BaseDataClass):
    """
    Defines additional optional features that can be included in an option contract.
    """
    fxFeature: List[cdm.product.template.FxFeature.FxFeature] = Field([], description="Describes a quanto or composite FX feature.")
    """
    Describes a quanto or composite FX feature.
    """
    strategyFeature: Optional[cdm.product.template.StrategyFeature.StrategyFeature] = Field(None, description="Defines a simple strategy feature.")
    """
    Defines a simple strategy feature.
    """
    averagingFeature: Optional[cdm.product.template.AveragingCalculation.AveragingCalculation] = Field(None, description="Defines an option feature in which an average market observation price is determined on valuation and compared to the strike to determine a settlement amount.")
    """
    Defines an option feature in which an average market observation price is determined on valuation and compared to the strike to determine a settlement amount.
    """
    barrier: Optional[cdm.product.template.Barrier.Barrier] = Field(None, description="Specifies a barrier feature.")
    """
    Specifies a barrier feature.
    """
    knock: Optional[cdm.product.template.Knock.Knock] = Field(None, description="Specifies a knock in or knock out feature.")
    """
    Specifies a knock in or knock out feature.
    """
    passThrough: Optional[cdm.product.template.PassThrough.PassThrough] = Field(None, description="Specifies the rules for pass-through payments from the underlier, such as dividends.")
    """
    Specifies the rules for pass-through payments from the underlier, such as dividends.
    """

import cdm 
import cdm.product.template.FxFeature
import cdm.product.template.StrategyFeature
import cdm.product.template.AveragingCalculation
import cdm.product.template.Barrier
import cdm.product.template.Knock
import cdm.product.template.PassThrough
