package drr.regulation.asic.rewrite.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class ASICMarginReportTypeFormatValidator implements Validator<ASICMarginReport> {

	private List<ComparisonResult> getComparisonResults(ASICMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("uniqueTransactionIdentifier", o.getUniqueTransactionIdentifier(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("uniqueTransactionIdentifierProprietary", o.getUniqueTransactionIdentifierProprietary(), 0, of(72), of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), 
				checkString("counterparty1", o.getCounterparty1(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("counterparty2", o.getCounterparty2(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("initialMarginCollateralPortfolioCode", o.getInitialMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("collateralPortfolioCodeVM", o.getCollateralPortfolioCodeVM(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkNumber("initialMarginPostedByTheReportingEntityPreHaircut", o.getInitialMarginPostedByTheReportingEntityPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginPostedByTheReportingEntityPostHaircut", o.getInitialMarginPostedByTheReportingEntityPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByTheReportingEntityPreHaircut", o.getInitialMarginCollectedByTheReportingEntityPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByTheReportingEntityPostHaircut", o.getInitialMarginCollectedByTheReportingEntityPostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByTheReportingEntityPreHaircut", o.getVariationMarginPostedByTheReportingEntityPreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByTheReportingEntityPreHaircut", o.getVariationMarginCollectedByTheReportingEntityPreHaircut(), of(25), of(5), empty(), empty()), 
				checkString("executionAgentOfCounterparty1", o.getExecutionAgentOfCounterparty1(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ASICMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "ASICMarginReport", path, "", res.getError());
				}
				return success("ASICMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "ASICMarginReport", path, "");
			})
			.collect(toList());
	}

}
