package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExtractCommodityClassificationLeg1.ExtractCommodityClassificationLeg1Default.class)
public abstract class ExtractCommodityClassificationLeg1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @param taxonomySource 
	* @param ordinal 
	* @return commodityClassification 
	*/
	public String evaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
		String commodityClassification = doEvaluate(product, taxonomySource, ordinal);
		
		return commodityClassification;
	}

	protected abstract String doEvaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal);

	protected abstract MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal);

	protected abstract MapperC<? extends ProductTaxonomy> taxonomy(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal);

	public static class ExtractCommodityClassificationLeg1Default extends ExtractCommodityClassificationLeg1 {
		@Override
		protected String doEvaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			String commodityClassification = null;
			return assignOutput(commodityClassification, product, taxonomySource, ordinal);
		}
		
		protected String assignOutput(String commodityClassification, Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			final MapperC<TaxonomyClassification> thenArg = MapperS.of(taxonomy(product, taxonomySource, ordinal).get()).<TaxonomyValue>map("getValue", productTaxonomy -> productTaxonomy.getValue()).<TaxonomyClassification>mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification())
				.filterItemNullSafe(item -> areEqual(item.<Integer>map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()), MapperS.of(ordinal), CardinalityOperator.All).get());
			commodityClassification = MapperS.of(thenArg.get()).<String>map("getValue", taxonomyClassification -> taxonomyClassification.getValue()).get();
			
			return commodityClassification;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			final Boolean boolean0 = qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(product));
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(underlierForProduct.evaluate(product)).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			if (ComparisonResult.ofNullSafe(MapperS.of(isCommoditySwaption.evaluate(product))).andNullSafe(exists(MapperS.of(commodityLeg1.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()))).getOrDefault(false)) {
				return MapperS.of(commodityLeg1.evaluate(underlierForProduct.evaluate(product))).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			if (ComparisonResult.ofNullSafe(MapperS.of(isCommoditySwap.evaluate(product))).andNullSafe(exists(MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()))).getOrDefault(false)) {
				return MapperS.of(commodityLeg1.evaluate(product)).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			final Boolean boolean1 = isCommodityFloatingPriceForward.evaluate(product);
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity());
			}
			return MapperS.<ReferenceWithMetaCommodity>ofNull();
		}
		
		@Override
		protected MapperC<? extends ProductTaxonomy> taxonomy(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
			return commodityUnderlier(product, taxonomySource, ordinal).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ProductTaxonomy>mapC("getProductTaxonomy", commodity -> commodity.getProductTaxonomy())
				.filterItemNullSafe(item -> areEqual(item.<TaxonomySourceEnum>map("getSource", productTaxonomy -> productTaxonomy.getSource()), MapperS.of(taxonomySource), CardinalityOperator.All).get());
		}
	}
}
