package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;


@ImplementedBy(GetProductQualifier.GetProductQualifierDefault.class)
public abstract class GetProductQualifier implements RosettaFunction {

	/**
	* @param productTaxonomy 
	* @return qualifier 
	*/
	public String evaluate(List<? extends ProductTaxonomy> productTaxonomy) {
		String qualifier = doEvaluate(productTaxonomy);
		
		return qualifier;
	}

	protected abstract String doEvaluate(List<? extends ProductTaxonomy> productTaxonomy);

	public static class GetProductQualifierDefault extends GetProductQualifier {
		@Override
		protected String doEvaluate(List<? extends ProductTaxonomy> productTaxonomy) {
			if (productTaxonomy == null) {
				productTaxonomy = Collections.emptyList();
			}
			String qualifier = null;
			return assignOutput(qualifier, productTaxonomy);
		}
		
		protected String assignOutput(String qualifier, List<? extends ProductTaxonomy> productTaxonomy) {
			final MapperC<String> thenArg = MapperC.<ProductTaxonomy>of(productTaxonomy)
				.mapItem(item -> item.<String>map("getProductQualifier", _productTaxonomy -> _productTaxonomy.getProductQualifier()));
			qualifier = MapperS.of(thenArg.get()).get();
			
			return qualifier;
		}
	}
}
