package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.TaxonomyValue;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.CommodityPayout;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.util.functions.StringContains;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsCommodityBullion.IsCommodityBullionDefault.class)
public abstract class IsCommodityBullion implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCRPBullion isCRPBullion;
	@Inject protected StringContains stringContains;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	protected abstract MapperS<? extends FieldWithMetaString> productIdentifier(Product product);

	protected abstract MapperS<? extends FieldWithMetaString> productTaxonomy(Product product);

	protected abstract MapperS<? extends FieldWithMetaString> productClass(Product product);

	protected abstract MapperS<? extends FieldWithMetaString> commodityReferencePrice(Product product);

	public static class IsCommodityBullionDefault extends IsCommodityBullion {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			if (exists(productClass(product)).andNullSafe(exists(commodityReferencePrice(product))).getOrDefault(false)) {
				final FieldWithMetaString fieldWithMetaString0 = productClass(product).get();
				final FieldWithMetaString fieldWithMetaString1 = commodityReferencePrice(product).get();
				result = ComparisonResult.ofNullSafe(MapperS.of(stringContains.evaluate((fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), "Metals:Precious"))).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCRPBullion.evaluate((fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()))))).get();
			} else {
				final FieldWithMetaString fieldWithMetaString2 = productClass(product).get();
				if (exists(productClass(product)).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(stringContains.evaluate((fieldWithMetaString2 == null ? null : fieldWithMetaString2.getValue()), "Metals:Precious")))).getOrDefault(false)) {
					result = true;
				} else {
					final FieldWithMetaString fieldWithMetaString3 = commodityReferencePrice(product).get();
					if (exists(commodityReferencePrice(product)).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCRPBullion.evaluate((fieldWithMetaString3 == null ? null : fieldWithMetaString3.getValue()))))).getOrDefault(false)) {
						result = true;
					} else {
						result = false;
					}
				}
			}
			
			return result;
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> productIdentifier(Product product) {
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg0 = MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier());
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier()).map("getMeta", a->a.getMeta()).map("getScheme", a->a.getScheme()), MapperS.of("http://www.fpml.org/coding-scheme/product-taxonomy"), CardinalityOperator.All).get());
			final MapperS<ReferenceWithMetaProductIdentifier> thenArg2 = MapperS.of(thenArg1.get());
			return thenArg2
				.mapSingleToItem(item -> item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier()));
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> productTaxonomy(Product product) {
			final MapperC<ProductTaxonomy> thenArg0 = MapperS.of(product).<ContractualProduct>map("getContractualProduct", _product -> _product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy());
			final MapperC<ProductTaxonomy> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<TaxonomySourceEnum>map("getSource", _productTaxonomy -> _productTaxonomy.getSource()), MapperS.of(TaxonomySourceEnum.ISDA), CardinalityOperator.All).get());
			final MapperS<ProductTaxonomy> thenArg2 = MapperS.of(thenArg1.get());
			return thenArg2
				.mapSingleToItem(item -> item.<TaxonomyValue>map("getValue", _productTaxonomy -> _productTaxonomy.getValue()).<FieldWithMetaString>map("getName", taxonomyValue -> taxonomyValue.getName()));
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> productClass(Product product) {
			if (exists(productTaxonomy(product)).andNullSafe(exists(productIdentifier(product))).getOrDefault(false)) {
				return MapperS.of(distinct(MapperC.<FieldWithMetaString>of(productTaxonomy(product), productIdentifier(product))).get());
			}
			if (exists(productTaxonomy(product)).getOrDefault(false)) {
				return productTaxonomy(product);
			}
			if (exists(productIdentifier(product)).getOrDefault(false)) {
				return productIdentifier(product);
			}
			return MapperS.<FieldWithMetaString>ofNull();
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> commodityReferencePrice(Product product) {
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg0 = MapperS.of(underlierForProduct.evaluate(product)).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", _productIdentifier -> _productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).get());
			final MapperS<ReferenceWithMetaProductIdentifier> thenArg2 = MapperS.of(thenArg1.get());
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg3 = MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<Product>map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).<ReferenceWithMetaCommodity>map("getCommodity", _product -> _product.getCommodity()).<Commodity>map("Type coercion", _referenceWithMetaCommodity -> _referenceWithMetaCommodity.getValue()).<ReferenceWithMetaProductIdentifier>mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
			final MapperC<ReferenceWithMetaProductIdentifier> thenArg4 = thenArg3
				.filterItemNullSafe(item -> areEqual(item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<ProductIdTypeEnum>map("getSource", _productIdentifier -> _productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISDACRP), CardinalityOperator.All).get());
			final MapperS<ReferenceWithMetaProductIdentifier> thenArg5 = MapperS.of(thenArg4.get());
			return MapperS.of(MapperC.<FieldWithMetaString>of(thenArg2
				.mapSingleToItem(item -> item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier())), thenArg5
				.mapSingleToItem(item -> item.<ProductIdentifier>map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier == null ? null : referenceWithMetaProductIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", _productIdentifier -> _productIdentifier.getIdentifier()))).get());
		}
	}
}
