package drr.regulation.common.functions;

import cdm.base.staticdata.party.NaturalPerson;
import cdm.base.staticdata.party.NaturalPersonRole;
import cdm.base.staticdata.party.NaturalPersonRoleEnum;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PersonIdentifier;
import cdm.base.staticdata.party.metafields.FieldWithMetaNaturalPersonRoleEnum;
import cdm.base.staticdata.party.metafields.FieldWithMetaPersonIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PartyIdentifierFormatEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PartyIdentifierFormat.PartyIdentifierFormatDefault.class)
public abstract class PartyIdentifierFormat implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected PartyIdentifierNaturalPersonRoles partyIdentifierNaturalPersonRoles;

	/**
	* @param party 
	* @return partyIdentifierFormat 
	*/
	public PartyIdentifierFormatEnum evaluate(Party party) {
		PartyIdentifierFormatEnum partyIdentifierFormat = doEvaluate(party);
		
		return partyIdentifierFormat;
	}

	protected abstract PartyIdentifierFormatEnum doEvaluate(Party party);

	protected abstract MapperS<? extends FieldWithMetaString> personId(Party party);

	public static class PartyIdentifierFormatDefault extends PartyIdentifierFormat {
		@Override
		protected PartyIdentifierFormatEnum doEvaluate(Party party) {
			PartyIdentifierFormatEnum partyIdentifierFormat = null;
			return assignOutput(partyIdentifierFormat, party);
		}
		
		protected PartyIdentifierFormatEnum assignOutput(PartyIdentifierFormatEnum partyIdentifierFormat, Party party) {
			if (exists(personId(party)).getOrDefault(false)) {
				partyIdentifierFormat = PartyIdentifierFormatEnum.LEI_AND_PERSON;
			} else {
				partyIdentifierFormat = PartyIdentifierFormatEnum.LEI;
			}
			
			return partyIdentifierFormat;
		}
		
		@Override
		protected MapperS<? extends FieldWithMetaString> personId(Party party) {
			final MapperS<Party> thenArg0 = MapperS.of(party)
				.filterSingleNullSafe(item -> areEqual(item.<NaturalPersonRole>mapC("getPersonRole", _party -> _party.getPersonRole()).<FieldWithMetaNaturalPersonRoleEnum>mapC("getRole", naturalPersonRole -> naturalPersonRole.getRole())
					.mapItem(r -> contains(MapperC.<NaturalPersonRoleEnum>of(partyIdentifierNaturalPersonRoles.evaluate()), r.<NaturalPersonRoleEnum>map("Type coercion", fieldWithMetaNaturalPersonRoleEnum -> fieldWithMetaNaturalPersonRoleEnum == null ? null : fieldWithMetaNaturalPersonRoleEnum.getValue())).asMapper()), MapperS.of(true), CardinalityOperator.Any).get());
			final MapperC<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToList(item -> item.<NaturalPerson>mapC("getPerson", _party -> _party.getPerson()).<FieldWithMetaPersonIdentifier>mapC("getPersonId", naturalPerson -> naturalPerson.getPersonId()).<PersonIdentifier>map("Type coercion", fieldWithMetaPersonIdentifier -> fieldWithMetaPersonIdentifier.getValue()).<FieldWithMetaString>map("getIdentifier", personIdentifier -> personIdentifier.getIdentifier()));
			return MapperS.of(thenArg1.get());
		}
	}
}
