package drr.regulation.common.trade.link.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(TechnicalRecordId.TechnicalRecordIdDefault.class)
public abstract class TechnicalRecordId implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param reportableInformation 
	* @param regime 
	* @return technicalRecordIdentifier 
	*/
	public drr.regulation.common.TechnicalRecordId evaluate(ReportableInformation reportableInformation, RegimeNameEnum regime) {
		drr.regulation.common.TechnicalRecordId.TechnicalRecordIdBuilder technicalRecordIdentifierBuilder = doEvaluate(reportableInformation, regime);
		
		final drr.regulation.common.TechnicalRecordId technicalRecordIdentifier;
		if (technicalRecordIdentifierBuilder == null) {
			technicalRecordIdentifier = null;
		} else {
			technicalRecordIdentifier = technicalRecordIdentifierBuilder.build();
			objectValidator.validate(drr.regulation.common.TechnicalRecordId.class, technicalRecordIdentifier);
		}
		
		return technicalRecordIdentifier;
	}

	protected abstract drr.regulation.common.TechnicalRecordId.TechnicalRecordIdBuilder doEvaluate(ReportableInformation reportableInformation, RegimeNameEnum regime);

	public static class TechnicalRecordIdDefault extends TechnicalRecordId {
		@Override
		protected drr.regulation.common.TechnicalRecordId.TechnicalRecordIdBuilder doEvaluate(ReportableInformation reportableInformation, RegimeNameEnum regime) {
			drr.regulation.common.TechnicalRecordId.TechnicalRecordIdBuilder technicalRecordIdentifier = drr.regulation.common.TechnicalRecordId.builder();
			return assignOutput(technicalRecordIdentifier, reportableInformation, regime);
		}
		
		protected drr.regulation.common.TechnicalRecordId.TechnicalRecordIdBuilder assignOutput(drr.regulation.common.TechnicalRecordId.TechnicalRecordIdBuilder technicalRecordIdentifier, ReportableInformation reportableInformation, RegimeNameEnum regime) {
			final MapperC<ReportingRegime> thenArg0 = MapperS.of(reportableInformation).<PartyInformation>mapC("getPartyInformation", _reportableInformation -> _reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation());
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaRegimeNameEnum>map("getRegimeName", reportingRegime -> reportingRegime.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(regime), CardinalityOperator.All).get());
			final MapperC<drr.regulation.common.TechnicalRecordId> ifThenElseResult;
			if (exists(thenArg1.<drr.regulation.common.TechnicalRecordId>map("getTechnicalRecordIdentifier", reportingRegime -> reportingRegime.getTechnicalRecordIdentifier())).getOrDefault(false)) {
				ifThenElseResult = thenArg1.<drr.regulation.common.TechnicalRecordId>map("getTechnicalRecordIdentifier", reportingRegime -> reportingRegime.getTechnicalRecordIdentifier());
			} else {
				final MapperC<FieldWithMetaString> thenArg2 = thenArg1.<FieldWithMetaString>map("getTechnicalRecordId", reportingRegime -> reportingRegime.getTechnicalRecordId());
				ifThenElseResult = MapperC.of(Collections.singletonList(drr.regulation.common.TechnicalRecordId.builder()
					.setId(MapperS.of(distinct(thenArg2).get()).get())
					.setIsUnique(null)
					.build()));
			}
			technicalRecordIdentifier = toBuilder(MapperS.of(distinct(ifThenElseResult).get()).get());
			
			return Optional.ofNullable(technicalRecordIdentifier)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
