package drr.regulation.common.validation;

import cdm.event.common.TradeIdentifier;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.ESMATransactionInformation;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class TransactionInformationValidator implements Validator<TransactionInformation> {

	private List<ComparisonResult> getComparisonResults(TransactionInformation o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("regimeName", (FieldWithMetaRegimeNameEnum) o.getRegimeName() != null ? 1 : 0, 1, 1), 
				checkCardinality("supervisoryBody", (FieldWithMetaSupervisoryBodyEnum) o.getSupervisoryBody() != null ? 1 : 0, 0, 1), 
				checkCardinality("transactionIdentifier", (TradeIdentifier) o.getTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorTransactionIdentifier", (TradeIdentifier) o.getPriorTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("esmaTransactionInformation", (ESMATransactionInformation) o.getEsmaTransactionInformation() != null ? 1 : 0, 0, 1), 
				checkCardinality("fcaTransactionInformation", (CommonTransactionInformation) o.getFcaTransactionInformation() != null ? 1 : 0, 0, 1), 
				checkCardinality("masTransactionInformation", (CommonTransactionInformation) o.getMasTransactionInformation() != null ? 1 : 0, 0, 1), 
				checkCardinality("csaTransactionInformation", (CommonTransactionInformation) o.getCsaTransactionInformation() != null ? 1 : 0, 0, 1), 
				checkCardinality("hkmaTransactionInformation", (CommonTransactionInformation) o.getHkmaTransactionInformation() != null ? 1 : 0, 0, 1), 
				checkCardinality("cftcTransactionInformation", (CommonTransactionInformation) o.getCftcTransactionInformation() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransactionInformation o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("TransactionInformation", ValidationResult.ValidationType.CARDINALITY, "TransactionInformation", path, "", res.getError());
				}
				return success("TransactionInformation", ValidationResult.ValidationType.CARDINALITY, "TransactionInformation", path, "");
			})
			.collect(toList());
	}

}
