package drr.regulation.csa.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.csa.rewrite.margin.CSAMarginReport;
import drr.regulation.csa.rewrite.margin.labels.CSAMarginLabelProvider;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.csa.rewrite.margin", body="CSA", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=CSAMarginLabelProvider.class)
@ImplementedBy(CSAMarginReportFunction.CSAMarginReportFunctionDefault.class)
public abstract class CSAMarginReportFunction implements ReportFunction<CollateralReportInstruction, CSAMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfInitialMarginCollectedRule currencyOfInitialMarginCollectedRule;
	@Inject protected CurrencyOfInitialMarginPostedRule currencyOfInitialMarginPostedRule;
	@Inject protected CurrencyOfVariationMarginCollectedRule currencyOfVariationMarginCollectedRule;
	@Inject protected CurrencyOfVariationMarginPostedRule currencyOfVariationMarginPostedRule;
	@Inject protected DTCC_Comment1Rule dTCC_Comment1Rule;
	@Inject protected DTCC_MessageIDRule dTCC_MessageIDRule;
	@Inject protected DTCC_MessageTypeRule dTCC_MessageTypeRule;
	@Inject protected DTCC_SubmittingPartyIDTypeRule dTCC_SubmittingPartyIDTypeRule;
	@Inject protected DTCC_TradeParty1IDTypeRule dTCC_TradeParty1IDTypeRule;
	@Inject protected DTCC_TradeParty1ReportingDestinationRule dTCC_TradeParty1ReportingDestinationRule;
	@Inject protected DTCC_USIIDPrefixRule dTCC_USIIDPrefixRule;
	@Inject protected DTCC_USIIDRule dTCC_USIIDRule;
	@Inject protected DTCC_VersionRule dTCC_VersionRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected InitialMarginCollectedByTheReportingCounterpartyPostHaircutRule initialMarginCollectedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected InitialMarginCollectedByTheReportingCounterpartyPreHaircutRule initialMarginCollectedByTheReportingCounterpartyPreHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterpartyPostHaircutRule initialMarginPostedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingCounterpartyPreHaircutRule initialMarginPostedByTheReportingCounterpartyPreHaircutRule;
	@Inject protected PortfolioContainingNonReportableComponentIndicatorRule portfolioContainingNonReportableComponentIndicatorRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;
	@Inject protected VariationMarginPostedByTheReportingCounterpartyPostHaircutRule variationMarginPostedByTheReportingCounterpartyPostHaircutRule;
	@Inject protected VariationMarginPostedByTheReportingCounterpartyPreHaircutRule variationMarginPostedByTheReportingCounterpartyPreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CSAMarginReport evaluate(CollateralReportInstruction input) {
		CSAMarginReport.CSAMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final CSAMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CSAMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract CSAMarginReport.CSAMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class CSAMarginReportFunctionDefault extends CSAMarginReportFunction {
		@Override
		protected CSAMarginReport.CSAMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			CSAMarginReport.CSAMarginReportBuilder output = CSAMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected CSAMarginReport.CSAMarginReportBuilder assignOutput(CSAMarginReport.CSAMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSource(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.setPortfolioContainingNonReportableComponentIndicator(portfolioContainingNonReportableComponentIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingCounterpartyPreHaircut(initialMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingCounterpartyPostHaircut(initialMarginPostedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfInitialMarginPosted(currencyOfInitialMarginPostedRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingCounterpartyPreHaircut(initialMarginCollectedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingCounterpartyPostHaircut(initialMarginCollectedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfInitialMarginCollected(currencyOfInitialMarginCollectedRule.evaluate(input));
			
			output
				.setVariationMarginPostedByTheReportingCounterpartyPreHaircut(variationMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setVariationMarginPostedByTheReportingCounterpartyPostHaircut(variationMarginPostedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginPosted(currencyOfVariationMarginPostedRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByTheReportingCounterpartyPreHaircut(variationMarginPostedByTheReportingCounterpartyPreHaircutRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByTheReportingCounterpartyPostHaircut(variationMarginPostedByTheReportingCounterpartyPostHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginCollected(currencyOfVariationMarginCollectedRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setTradeParty1IDType(dTCC_TradeParty1IDTypeRule.evaluate(input));
			
			output
				.setSubmittingPartyIDType(dTCC_SubmittingPartyIDTypeRule.evaluate(input));
			
			output
				.setUsiID(dTCC_USIIDRule.evaluate(input));
			
			output
				.setUsiIDPrefix(null);
			
			output
				.setTradeParty1ReportingDestination(dTCC_TradeParty1ReportingDestinationRule.evaluate(input));
			
			output
				.setComment1(null);
			
			output
				.setMessageID(dTCC_MessageIDRule.evaluate(input));
			
			output
				.setMessageType(dTCC_MessageTypeRule.evaluate(input));
			
			output
				.setVersion(dTCC_VersionRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
