package drr.regulation.csa.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;


@ImplementedBy(DTCC_USIIDPrefixRule.DTCC_USIIDPrefixRuleDefault.class)
public abstract class DTCC_USIIDPrefixRule implements ReportFunction<CollateralReportInstruction, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(CollateralReportInstruction input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(CollateralReportInstruction input);

	public static class DTCC_USIIDPrefixRuleDefault extends DTCC_USIIDPrefixRule {
		@Override
		protected Void doEvaluate(CollateralReportInstruction input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, CollateralReportInstruction input) {
			output = null;
			
			return output;
		}
	}
}
