package drr.regulation.csa.rewrite.trade.reports;

import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentNumberOfUnitsRule.BasketConstituentNumberOfUnitsRuleDefault.class)
public abstract class BasketConstituentNumberOfUnitsRule implements ReportFunction<BasketConstituent, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.basket.reports.BasketConstituentNumberOfUnitsRule basketConstituentNumberOfUnitsRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(BasketConstituent input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(BasketConstituent input);

	public static class BasketConstituentNumberOfUnitsRuleDefault extends BasketConstituentNumberOfUnitsRule {
		@Override
		protected BigDecimal doEvaluate(BasketConstituent input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, BasketConstituent input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(basketConstituentNumberOfUnitsRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
