package drr.regulation.fca.ukemir.refit.margin.reports;

import cdm.base.datetime.functions.Now;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import java.time.ZonedDateTime;
import javax.inject.Inject;


@ImplementedBy(ReportingTimestampRule.ReportingTimestampRuleDefault.class)
public abstract class ReportingTimestampRule implements ReportFunction<CollateralReportInstruction, ZonedDateTime> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Now now;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ZonedDateTime evaluate(CollateralReportInstruction input) {
		ZonedDateTime output = doEvaluate(input);
		
		return output;
	}

	protected abstract ZonedDateTime doEvaluate(CollateralReportInstruction input);

	public static class ReportingTimestampRuleDefault extends ReportingTimestampRule {
		@Override
		protected ZonedDateTime doEvaluate(CollateralReportInstruction input) {
			ZonedDateTime output = null;
			return assignOutput(output, input);
		}
		
		protected ZonedDateTime assignOutput(ZonedDateTime output, CollateralReportInstruction input) {
			output = now.evaluate();
			
			return output;
		}
	}
}
