package drr.regulation.fca.ukemir.refit.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.enrichment.common.EnrichmentData;
import drr.enrichment.lei.LeiData;
import drr.enrichment.lei.functions.GetOrFetchLeiData;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.fca.ukemir.refit.margin.CollateralReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRMarginReport;
import drr.regulation.fca.ukemir.refit.margin.FCAUKEMIRNonReportableCollateralData;
import drr.regulation.fca.ukemir.refit.margin.PartiesToTheDerivative;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 6.21.2
 */
@RosettaDataRule("FCAUKEMIRMarginReportEMIR_VR_3030_03")
@ImplementedBy(FCAUKEMIRMarginReportEMIR_VR_3030_03.Default.class)
public interface FCAUKEMIRMarginReportEMIR_VR_3030_03 extends Validator<FCAUKEMIRMarginReport> {
	
	String NAME = "FCAUKEMIRMarginReportEMIR_VR_3030_03";
	String DEFINITION = "if [MarginActionEnum -> MARU, MarginActionEnum -> CORR] any = collateral -> actionType then ( if partiesToTheDerivative -> executionAgentOfCounterparty1 exists and partiesToTheDerivative -> executionAgentOfCounterparty2 is absent then GetOrFetchLeiData( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty1 ) exists else if partiesToTheDerivative -> executionAgentOfCounterparty2 exists and partiesToTheDerivative -> executionAgentOfCounterparty1 is absent then GetOrFetchLeiData( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty2 ) exists else if partiesToTheDerivative -> executionAgentOfCounterparty1 exists and partiesToTheDerivative -> executionAgentOfCounterparty2 exists then GetOrFetchLeiData( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty1 ) exists and GetOrFetchLeiData( partiesToTheDerivative -> nonReportable -> enrichment -> leiData, partiesToTheDerivative -> executionAgentOfCounterparty2 ) exists)";
	
	class Default implements FCAUKEMIRMarginReportEMIR_VR_3030_03 {
	
		@Inject protected GetOrFetchLeiData getOrFetchLeiData;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRMarginReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			try {
				if (areEqual(MapperC.<MarginActionEnum>of(MapperS.of(MarginActionEnum.MARU), MapperS.of(MarginActionEnum.CORR)), MapperS.of(fCAUKEMIRMarginReport).<CollateralReport>map("getCollateral", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getCollateral()).<MarginActionEnum>map("getActionType", collateralReport -> collateralReport.getActionType()), CardinalityOperator.Any).getOrDefault(false)) {
					if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1())).andNullSafe(notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()))).getOrDefault(false)) {
						return exists(MapperS.of(getOrFetchLeiData.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1()).get())));
					}
					if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2())).andNullSafe(notExists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1()))).getOrDefault(false)) {
						return exists(MapperS.of(getOrFetchLeiData.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()).get())));
					}
					if (exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1())).andNullSafe(exists(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()))).getOrDefault(false)) {
						return exists(MapperS.of(getOrFetchLeiData.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty1()).get()))).andNullSafe(exists(MapperS.of(getOrFetchLeiData.evaluate(MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<FCAUKEMIRNonReportableCollateralData>map("getNonReportable", partiesToTheDerivative -> partiesToTheDerivative.getNonReportable()).<EnrichmentData>map("getEnrichment", fCAUKEMIRNonReportableCollateralData -> fCAUKEMIRNonReportableCollateralData.getEnrichment()).<LeiData>mapC("getLeiData", enrichmentData -> enrichmentData.getLeiData()).getMulti(), MapperS.of(fCAUKEMIRMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _fCAUKEMIRMarginReport -> _fCAUKEMIRMarginReport.getPartiesToTheDerivative()).<String>map("getExecutionAgentOfCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getExecutionAgentOfCounterparty2()).get()))));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRMarginReportEMIR_VR_3030_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRMarginReport fCAUKEMIRMarginReport) {
			return Collections.emptyList();
		}
	}
}
