package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg1Rule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SpreadOfLeg1Rule.SpreadOfLeg1RuleDefault.class)
public abstract class SpreadOfLeg1Rule implements ReportFunction<TransactionReportInstruction, PriceFormat> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNameOfTheFloatingRateOfLeg1 getNameOfTheFloatingRateOfLeg1;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected PriceFormatFromNotation priceFormatFromNotation;
	@Inject protected SpreadLeg1Rule spreadLeg1Rule;
	@Inject protected SpreadOfLeg1NotationRule spreadOfLeg1NotationRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceFormat evaluate(TransactionReportInstruction input) {
		PriceFormat.PriceFormatBuilder outputBuilder = doEvaluate(input);
		
		final PriceFormat output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(PriceFormat.class, output);
		}
		
		return output;
	}

	protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg1RuleDefault extends SpreadOfLeg1Rule {
		@Override
		protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
			PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
			return assignOutput(output, input);
		}
		
		protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = toBuilder(thenArg
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = spreadLeg1Rule.evaluate(item.get());
					if ((priceSchedule == null ? exists(MapperS.<ReferenceWithMetaPriceSchedule>ofNull()).getOrDefault(false) : exists(MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(false))) {
						return MapperS.of(priceFormatFromNotation.evaluate(MapperS.of(spreadLeg1Rule.evaluate(item.get())).<BigDecimal>map("getValue", _priceSchedule -> _priceSchedule.getValue()).get(), spreadOfLeg1NotationRule.evaluate(item.get())));
					}
					if (exists(MapperS.of(getNameOfTheFloatingRateOfLeg1.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(PriceFormat.builder()
							.setBasis(BigDecimal.valueOf(0))
							.build());
					}
					return MapperS.<PriceFormat>ofNull();
				}).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
