package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRNonReportable;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class FCAUKEMIRNonReportableTypeFormatValidator implements Validator<FCAUKEMIRNonReportable> {

	private List<ComparisonResult> getComparisonResults(FCAUKEMIRNonReportable o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRNonReportable o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("FCAUKEMIRNonReportable", ValidationResult.ValidationType.TYPE_FORMAT, "FCAUKEMIRNonReportable", path, "", res.getError());
				}
				return success("FCAUKEMIRNonReportable", ValidationResult.ValidationType.TYPE_FORMAT, "FCAUKEMIRNonReportable", path, "");
			})
			.collect(toList());
	}

}
