package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 6.21.2
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2048_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2048_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2048_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2048_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if (contractType = FORW and assetClass = COMM) or ([CommonContractType -> FORW, CommonContractType -> SWAP] any = contractType and assetClass = EQUI) or [CommonContractType -> CFDS, CommonContractType -> FUTR] any = contractType then price -> monetary exists or price -> percentage exists";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2048_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<ActionTypeEnum>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperS.of(fCAUKEMIRTransactionReport).<CommonContractType>map("getContractType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getContractType()), MapperS.of(CommonContractType.FORW), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(fCAUKEMIRTransactionReport).<CommonAssetClass>map("getAssetClass", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.COMM), CardinalityOperator.All)).orNullSafe(areEqual(MapperC.<CommonContractType>of(MapperS.of(CommonContractType.FORW), MapperS.of(CommonContractType.SWAP)), MapperS.of(fCAUKEMIRTransactionReport).<CommonContractType>map("getContractType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getContractType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(fCAUKEMIRTransactionReport).<CommonAssetClass>map("getAssetClass", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.EQUI), CardinalityOperator.All))).orNullSafe(areEqual(MapperC.<CommonContractType>of(MapperS.of(CommonContractType.CFDS), MapperS.of(CommonContractType.FUTR)), MapperS.of(fCAUKEMIRTransactionReport).<CommonContractType>map("getContractType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getContractType()), CardinalityOperator.Any)).getOrDefault(false)) {
						return exists(MapperS.of(fCAUKEMIRTransactionReport).<PriceFormat>map("getPrice", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary())).orNullSafe(exists(MapperS.of(fCAUKEMIRTransactionReport).<PriceFormat>map("getPrice", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getPrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage())));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2048_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
