package drr.regulation.hkma.rewrite.trade.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.hkma.rewrite.trade.functions.IsAllowableActionForHKMA;
import drr.standards.iosco.cde.version3.payment.reports.PeriodicPaymentRule;
import javax.inject.Inject;


@ImplementedBy(FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.FixedRatePaymentFrequencyPeriodMultiplierLeg2RuleDefault.class)
public abstract class FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule implements ReportFunction<TransactionReportInstruction, Integer> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected IsAllowableActionForHKMA isAllowableActionForHKMA;
	@Inject protected PeriodicPaymentRule periodicPaymentRule;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Integer evaluate(TransactionReportInstruction input) {
		Integer output = doEvaluate(input);
		
		return output;
	}

	protected abstract Integer doEvaluate(TransactionReportInstruction input);

	public static class FixedRatePaymentFrequencyPeriodMultiplierLeg2RuleDefault extends FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule {
		@Override
		protected Integer doEvaluate(TransactionReportInstruction input) {
			Integer output = null;
			return assignOutput(output, input);
		}
		
		protected Integer assignOutput(Integer output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForHKMA.evaluate(item.get()));
			final MapperS<InterestRatePayout> thenArg1 = MapperS.of(interestRateLeg2.evaluate(productOrUnderlierProduct.evaluate(productForEvent.evaluate(thenArg0.get()))));
			output = MapperS.of(periodicPaymentRule.evaluate(thenArg1.get())).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", periodicPayment -> periodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
			
			return output;
		}
	}
}
