package drr.regulation.jfsa.rewrite.margin;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.jfsa.rewrite.margin.meta.PartiesToTheDerivativeMeta;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.21.2
 */
@RosettaDataType(value="PartiesToTheDerivative", builder=PartiesToTheDerivative.PartiesToTheDerivativeBuilderImpl.class, version="6.21.2")
@RuneDataType(value="PartiesToTheDerivative", model="drr", builder=PartiesToTheDerivative.PartiesToTheDerivativeBuilderImpl.class, version="6.21.2")
public interface PartiesToTheDerivative extends RosettaModelObject {

	PartiesToTheDerivativeMeta metaData = new PartiesToTheDerivativeMeta();

	/*********************** Getter Methods  ***********************/
	ZonedDateTime getReportingTimestamp();
	String getSubmitterIdentifier();
	String getEntityResponsibleForReporting();
	String getCounterparty1();
	Boolean getCounterparty2IdentifierType();
	String getCounterparty2();

	/*********************** Build Methods  ***********************/
	PartiesToTheDerivative build();
	
	PartiesToTheDerivative.PartiesToTheDerivativeBuilder toBuilder();
	
	static PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder() {
		return new PartiesToTheDerivative.PartiesToTheDerivativeBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PartiesToTheDerivative> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PartiesToTheDerivative> getType() {
		return PartiesToTheDerivative.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PartiesToTheDerivativeBuilder extends PartiesToTheDerivative, RosettaModelObjectBuilder {
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setSubmitterIdentifier(String submitterIdentifier);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty1(String counterparty1);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2(String counterparty2);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, getSubmitterIdentifier(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		}
		

		PartiesToTheDerivative.PartiesToTheDerivativeBuilder prune();
	}

	/*********************** Immutable Implementation of PartiesToTheDerivative  ***********************/
	class PartiesToTheDerivativeImpl implements PartiesToTheDerivative {
		private final ZonedDateTime reportingTimestamp;
		private final String submitterIdentifier;
		private final String entityResponsibleForReporting;
		private final String counterparty1;
		private final Boolean counterparty2IdentifierType;
		private final String counterparty2;
		
		protected PartiesToTheDerivativeImpl(PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder) {
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.submitterIdentifier = builder.getSubmitterIdentifier();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.counterparty2 = builder.getCounterparty2();
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		public PartiesToTheDerivative build() {
			return this;
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder toBuilder() {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PartiesToTheDerivative.PartiesToTheDerivativeBuilder builder) {
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PartiesToTheDerivative _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PartiesToTheDerivative {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"counterparty2=" + this.counterparty2 +
			'}';
		}
	}

	/*********************** Builder Implementation of PartiesToTheDerivative  ***********************/
	class PartiesToTheDerivativeBuilderImpl implements PartiesToTheDerivative.PartiesToTheDerivativeBuilder {
	
		protected ZonedDateTime reportingTimestamp;
		protected String submitterIdentifier;
		protected String entityResponsibleForReporting;
		protected String counterparty1;
		protected Boolean counterparty2IdentifierType;
		protected String counterparty2;
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		public String getSubmitterIdentifier() {
			return submitterIdentifier;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="submitterIdentifier", isRequired=true)
		@RuneAttribute(value="submitterIdentifier", isRequired=true)
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setSubmitterIdentifier(String _submitterIdentifier) {
			this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
			return this;
		}
		
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		public PartiesToTheDerivative build() {
			return new PartiesToTheDerivative.PartiesToTheDerivativeImpl(this);
		}
		
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getReportingTimestamp()!=null) return true;
			if (getSubmitterIdentifier()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getCounterparty2()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PartiesToTheDerivative.PartiesToTheDerivativeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PartiesToTheDerivative.PartiesToTheDerivativeBuilder o = (PartiesToTheDerivative.PartiesToTheDerivativeBuilder) other;
			
			
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getSubmitterIdentifier(), o.getSubmitterIdentifier(), this::setSubmitterIdentifier);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PartiesToTheDerivative _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(submitterIdentifier, _that.getSubmitterIdentifier())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (submitterIdentifier != null ? submitterIdentifier.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PartiesToTheDerivativeBuilder {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"submitterIdentifier=" + this.submitterIdentifier + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"counterparty2=" + this.counterparty2 +
			'}';
		}
	}
}
