package drr.regulation.mas.rewrite.margin.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.CollateralReportInstruction;
import drr.regulation.common.ReportingSide;
import drr.standards.iosco.cde.version3.collateral.functions.VariationMarginCollectedByReportingCounterpartyCurrency;
import javax.inject.Inject;


@ImplementedBy(VariationMarginCollectedByCounterparty1CurrencyRule.VariationMarginCollectedByCounterparty1CurrencyRuleDefault.class)
public abstract class VariationMarginCollectedByCounterparty1CurrencyRule implements ReportFunction<CollateralReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected VariationMarginCollectedByReportingCounterpartyCurrency variationMarginCollectedByReportingCounterpartyCurrency;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(CollateralReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(CollateralReportInstruction input);

	public static class VariationMarginCollectedByCounterparty1CurrencyRuleDefault extends VariationMarginCollectedByCounterparty1CurrencyRule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(CollateralReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, CollateralReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final ReferenceWithMetaParty referenceWithMetaParty = item.<ReportingSide>map("getReportingSide", collateralReportInstruction -> collateralReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
					return MapperS.of(variationMarginCollectedByReportingCounterpartyCurrency.evaluate(item.get(), (referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue())));
				}).get();
			
			return output;
		}
	}
}
